package kqi;
/*

 Sample Axis2 Java code calling SOAP methods 'start', 'sendMessage' and 'browseDestionationsBySeqId' 
 as declared in http://soap.kqumg.it/chaka/current/0.9.5/Chaka.wsdl 

 (written by Massimiliano Muzi <max.muzi@kqi.it> on 12/01/2011)
 
*/

/*

  To compile the following code you need to:
   1. download Axis2 from http://axis.apache.org/axis2/java/core/download.cgi
   2. generate _5._9.chaka_0.* classes via Axis2's bin/wsdl2java.sh (or wsdl2java.bat)
   2. include all Axis2 jar files and _5._9.chaka_0 classes into your project  
  
  Change userid, passwd and smsPhoneNumber variables below to match your own KQI credentials and phone number.
  
*/

import java.rmi.RemoteException;

import org.apache.axis2.databinding.types.PositiveInteger;
import org.apache.axis2.databinding.types.Token;
import org.apache.axis2.databinding.types.URI;
import org.apache.axis2.databinding.types.URI.MalformedURIException;


// these classes have been generated by bin/wsdl2java.sh
import _5._9.chaka_0.ChakaStub;
import _5._9.chaka_0.ChakaStub.BrowseDestinationsBySeqId;
import _5._9.chaka_0.ChakaStub.BrowseDestinationsBySeqIdResponse;
import _5._9.chaka_0.ChakaStub.Destination;
import _5._9.chaka_0.ChakaStub.DestinationList;
import _5._9.chaka_0.ChakaStub.Message;
import _5._9.chaka_0.ChakaStub.MessageChoice_type0;
import _5._9.chaka_0.ChakaStub.SMSMessage;
import _5._9.chaka_0.ChakaStub.SMSMessageChoice_type0;
import _5._9.chaka_0.ChakaStub.SendMessage;
import _5._9.chaka_0.ChakaStub.SendMessageResponse;
import _5._9.chaka_0.ChakaStub.Start;
import _5._9.chaka_0.ChakaStub.StartResponse;
import _5._9.chaka_0.ChakaStub.UserOptions;


public class ChakaTest {

	static public void main(String[] args) throws RemoteException, MalformedURIException
 {
	
		String userid = "USER@EXAMPLE.COM";
		String passwd = "PASSWORD";
		String contactEmail = "mailto:" + "CONTACT_PERSON@EXAMPLE.COM";
		
		String  smsPhoneNumber = "YOUR PHONE NUMBER";
		
		String  msgContent = "test sms 123";
		String  msgSubject = "Test SMS via SOAP from Java/Axis2";
		
		String msgReqUid = java.util.UUID.randomUUID().toString();
		
		
			
		ChakaStub ch = new ChakaStub();
		
		
		// calling start(user,password, options)
		Start start_args = new Start();
		start_args.setUserid(userid);
		start_args.setPassword(passwd);
		UserOptions userOptions = new UserOptions();
		userOptions.setContactPerson(new URI(contactEmail));
		start_args.setOptions(userOptions);
		StartResponse startResp = ch.start(start_args);
		Token authToken = startResp.getAuth();
		
		System.out.println(authToken);

		// calling sendMessage( auth, requid, message ) ...
		
		SMSMessage smsMsg = new SMSMessage();
		smsMsg.setShortMsg( msgContent);
		
		DestinationList destList = new DestinationList();
		Destination dest = new Destination();
		dest.setAddress(smsPhoneNumber);
		
		destList.addItem(dest);
		
		SMSMessageChoice_type0 smsMsgChoice0 = new SMSMessageChoice_type0();
		smsMsgChoice0.setDestinations(destList );
		smsMsg.setSMSMessageChoice_type0(smsMsgChoice0);
		
		MessageChoice_type0 messageChoice0 = new MessageChoice_type0();
		messageChoice0.setSms(smsMsg);
		
		
		Message message = new Message();
		message.setMessageChoice_type0(messageChoice0);
		message.setSubject(msgSubject);
		
		SendMessage sendMessage_args = new SendMessage();
		sendMessage_args.setAuth(authToken);
		sendMessage_args.setRequestUid(new Token(msgReqUid));
		sendMessage_args.setMessage(message);
		
		SendMessageResponse sendResp = ch.sendMessage(sendMessage_args);
		System.out.println(sendResp.getResult().getInfo().getMsgId());
		
		PositiveInteger msgid = sendResp.getResult().getInfo().getMsgId() ;
		
		
		// calling browseDestinationsBySeqId( auth, msgid, 1, 1 ) ...
		
		BrowseDestinationsBySeqId browseDestinationsBySeqId_args = new BrowseDestinationsBySeqId();
		browseDestinationsBySeqId_args.setAuth(authToken);
		browseDestinationsBySeqId_args.setMsgId(msgid);
		browseDestinationsBySeqId_args.setFirst(new PositiveInteger("1"));
		browseDestinationsBySeqId_args.setLast(new PositiveInteger("1"));
				
		BrowseDestinationsBySeqIdResponse browseResp = ch.browseDestinationsBySeqId(browseDestinationsBySeqId_args );
		
		System.out.println(browseResp.getMsgSummary().getSubject());
		System.out.println(browseResp.getMsgSummary().getDestCount() ); // this should be 1
		System.out.println(browseResp.getMsgSummary().getCompletedDestCount() ); // this should be 0


	}


}
