package it.kqi.chaka095.demo;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import javax.activation.DataHandler;

import org.apache.axis2.AxisFault;
import org.apache.axis2.databinding.types.NMTokens;
import org.apache.axis2.databinding.types.PositiveInteger;
import org.apache.axis2.databinding.types.Token;
import org.apache.axis2.databinding.types.URI;
import org.apache.axis2.databinding.types.URI.MalformedURIException;

import it.kqumg.soap.chaka095.http.*;

/**
 * FAXSender consente di inviare messaggi FAX di tipo semplice o di tipo
 * "personalizzato". L'implementazione dei vari metodi è basata sulle classi
 * generate dal tool wsdl2java da Axis2. Lo scopo di questa classe è quella
 * nascondere alcune complessità dell'interfaccia SOAP.
 */
public class FAXSender {
	private class StartOptions {

		public final String userid;
		public final String password;
		public final String contactPerson;
		public final String callbackURL;

		/**
		 * @param userid
		 * @param password
		 * @param contactPerson
		 * @param callbackURL
		 */
		public StartOptions(String userid, String password,
				String contactPerson, String callbackURL) {
			super();
			this.userid = userid;
			this.password = password;
			this.contactPerson = contactPerson;
			this.callbackURL = callbackURL;
		}

	}

	private StartOptions startOptions;
	private Token authToken;
	private ChakaStub client;
	

	/**
	 * @param userid
	 * @param password
	 * @param contactPerson
	 * @param callbackURL
	 * @throws AxisFault
	 * 
	 *             Inizializza un'istanza di FAXSender con i dettagli per
	 *             autenticazione. Il parametro callbackURL può essere null se
	 *             non si desidera sfruttare la funzionlità di callback.
	 *             Diversamente deve puntare all'endpoint (http, non https) del
	 *             servizio Chaka_CB (v. manuale).
	 */
	public FAXSender(String userid, String password, String contactPerson,
			String callbackURL) throws AxisFault {
		this.startOptions = new StartOptions(userid, password, contactPerson,
				callbackURL);
		this.client = new ChakaStub();
	}

	/**
	 * @param authToken
	 * @throws AxisFault
	 * 
	 *             Inizializza un'istanza di FAXSender con il token di
	 *             autenticazione. Questo consente di utilizzare una sessione
	 *             precedentemente aperta (risparmiando, così una chiamata al
	 *             metodo SOAP "start"). Il metodo getAuthToken consente di
	 *             ricavare il token corrente (al fine di salvarlo per
	 *             successivi utilizzi).
	 */
	public FAXSender(Token authToken) throws AxisFault {
		this.authToken = authToken;
		this.client = new ChakaStub();
	}

	/**
	 * @throws MalformedURIException
	 * @throws RemoteException
	 * 
	 *             Inizia una sessione invocando il metodo SOAP "start". Il
	 *             token viene salvato in authToken. Questo metodo viene
	 *             implicitamente chiamato da sendMessage, se authToken non è
	 *             ancora stato valorizzato.
	 */
	public void startSession() throws MalformedURIException, RemoteException {

		ChakaStub.Start startArgs = new ChakaStub.Start();
		startArgs.setUserid(this.startOptions.userid);
		startArgs.setPassword(this.startOptions.password);
		ChakaStub.UserOptions userOptions = new ChakaStub.UserOptions();
		userOptions.setContactPerson(new URI(this.startOptions.contactPerson));
		if (this.startOptions.callbackURL != null) {
			userOptions.setSoapCallback(new URI(this.startOptions.callbackURL));
		}
		startArgs.setOptions(userOptions);
		ChakaStub.StartResponse startResp = this.client.start(startArgs);
		this.authToken = startResp.getAuth();
	}

	Token getAuthToken() {
		return this.authToken;
	}

	/**
	 * La classe Destination rappresenta una semplice destinazone FAX.
	 */
	public static class Destination {
		public Destination(String address, String cc1, String cc2) {
			super();
			this.address = address;
			this.cc1 = cc1;
			this.cc2 = cc2;
		}

		public String address;
		public String cc1;
		public String cc2;
	}

	
	/**
	 * @param reqUID
	 * @param subject
	 * @param text
	 * @param destinations
	 * @return
	 * @throws MalformedURIException
	 * @throws RemoteException
	 * @throws MalformedURLException
	 * 
	 *             <P>
	 *             Questa versione di sendMessage crea una spedizione FAX in cui
	 *             ogni destinatario riceve lo stesso messaggio. Questo metodo
	 *             effettua la chiamata SOAP "sendMessage". Il valore restituito
	 *             è il codice del messaggio ("msg-id")
	 * 
	 * 
	 */
	PositiveInteger sendMessage(String reqUID, String subject, File file, 
			Destination[] destinations,  java.util.Calendar scheduling)
			throws MalformedURIException, RemoteException,
			MalformedURLException {
		if (getAuthToken() == null) {
			startSession();
		}

		ChakaStub.DestinationList destList = new ChakaStub.DestinationList();
		/*
		 */
		NMTokens flags = new NMTokens("");
		for (Destination destination : destinations) {
			ChakaStub.Destination dest = new ChakaStub.Destination();
			dest.setAddress(destination.address);
			dest.setCc1(destination.cc1);
			if (this.senderString != null) {
				ChakaStub.DestinationExtraAttributes extraAttrs = new ChakaStub.DestinationExtraAttributes();
				extraAttrs.setA1(this.senderString);
				dest.setExtra(extraAttrs);
			} else {
				dest.setCc2(destination.cc2);
			}
			destList.addItem(dest);
		}
		
		ChakaStub.StorableDestinationListChoice_type0 storableDestListChoice_type0 = new ChakaStub.StorableDestinationListChoice_type0();
		storableDestListChoice_type0.setList(destList);
		
		
		ChakaStub.StorableDestinationList storableDestList = new ChakaStub.StorableDestinationList();
		storableDestList.setStorableDestinationListChoice_type0(storableDestListChoice_type0);
		
		String destListName = java.util.UUID.randomUUID().toString();
		
		storableDestList.setUniqueName(destListName);
		
		
				
		
		ChakaStub.StoreDestinationList storeDstListArgs = new ChakaStub.StoreDestinationList();
		
		storeDstListArgs.setAuth(this.getAuthToken());
		storeDstListArgs.setList(storableDestList);
		
		ChakaStub.StoreDestinationListResponse storeDestListResp = this.client.storeDestinationList(storeDstListArgs);
		

		ChakaStub.FAXMessage faxMsg = new ChakaStub.FAXMessage();

		/*
		 * Il tipo FAXMessageChoice_type0 è generato da Axis2 per controllare i
		 * vari modi in cui l'elemento SOAP di tipo "choice" interno a
		 * FAXMessagge può essere valorizzato. Nel nostro caso, viene impostato
		 * "destinations".
		 * 
		 * Le altre classi che terminano in "Choice_type0" svolgono un ruolo
		 * analogo nelle altre strutture SOAP che contengono elementi "choice"
		 */
		ChakaStub.FAXMessageChoice_type0 faxMsgChoice0 = new ChakaStub.FAXMessageChoice_type0();
		faxMsgChoice0.setDestinationListName(storeDestListResp.getName());

		faxMsg.setFAXMessageChoice_type0(faxMsgChoice0);

		ChakaStub.MessageChoice_type0 messageChoice0 = new ChakaStub.MessageChoice_type0();
		messageChoice0.setFax(faxMsg);

		
		ChakaStub.MessageOptions opts = new ChakaStub.MessageOptions();
		opts.setFlags(flags);
		if (scheduling != null) {
			opts.setScheduling(scheduling);
		}
		
		ChakaStub.Message message = new ChakaStub.Message();
		message.setMessageChoice_type0(messageChoice0);
		message.setSubject(subject);
		message.setOptions(opts);

		DataHandler data = new DataHandler(new URL("file:" + file.getAbsolutePath()));

		ChakaStub.Document doc = new ChakaStub.Document();
		doc.setContentType("ignored");
		doc.setUniqueName(file.getName());
		doc.setData(data);

		ChakaStub.DocumentChoiceElement docChoiceEl = new ChakaStub.DocumentChoiceElement();
		docChoiceEl.setDocument(doc);

		ChakaStub.DocumentList docList = new ChakaStub.DocumentList();
		docList.addItem(docChoiceEl);
		faxMsg.setDocuments(docList);

		return this.sendChakaMessage(reqUID, message);
	}

	private PositiveInteger sendChakaMessage(String reqUID,
			ChakaStub.Message message) throws RemoteException {
		ChakaStub.SendMessage sendMessageArgs = new ChakaStub.SendMessage();
		sendMessageArgs.setAuth(this.authToken);
		sendMessageArgs.setRequestUid(new Token(reqUID));
		sendMessageArgs.setMessage(message);
		ChakaStub.SendMessageResponse sendResp = this.client
				.sendMessage(sendMessageArgs);
		return sendResp.getResult().getInfo().getMsgId();
	}


}
