﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using Chaka;
using Chaka.ChakaDevelReference;

namespace MessageSender
{
    internal class Program
    {
        private static void Main(string[] args)
        {
            String ServiceURL = @"http://soap.kqumg.it/chaka/current/0.9.5/exec";
            String UserId = "example@example.com";
            String Password = "p4ssw0rd";
            String ContactEmail = "mailto: " + UserId;
            String CallbackURL = null;

            String FilePath = @"C:\sample.pdf";
            String faxNum0 = "00393330000001";

            var faxSender = new FAXSender(ServiceURL, UserId, Password, ContactEmail, CallbackURL);

            try
            {
                var documentContent = File.ReadAllBytes(FilePath);
                var documentUniqueName = Path.GetFileName(FilePath);

                var correlation = faxSender.SendMessage(
                    Guid.NewGuid().ToString(),
                    "Test FAX via SOAP",
                    documentUniqueName,
                    documentContent,

                    // Dato che la seconda destinazione è identica alla prima, sarà subito marcata come "CANCELLED DUPLICATE" 
                    new List<Destination>()
                        {
                            new Destination()
                                {
                                    address = faxNum0,
                                    cc2 = "",
                                    cc1 = ""
                                },
                            new Destination()
                                {
                                    address = faxNum0,
                                    cc2 = "",
                                    cc1 = ""
                                }
                        },
                    // Questo messaggio partirà con 5 minuti di ritardo
                    DateTime.Now.AddMinutes(5)
                    );

                Console.WriteLine(faxSender.getAuthToken());
                Console.WriteLine(correlation);
            }
            catch (Exception e)
            {
                Console.WriteLine(e.Message);
            }

            Console.ReadLine();
        }
    }
}
