﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using Chaka.ChakaDevelReference;
using System.Xml.Schema;
using System.ServiceModel;

namespace Chaka
{
    public class FAXSender
    {
        public FAXSender(String serviceURL, String userid, String password, 
		                       String contactEmail, String callBackURL)
        {
            this._userId = userid;
            this._password = password;
            this._contactEmail = contactEmail;
            this._callbackURL = callBackURL;
            this._serviceURL = serviceURL;
        }

        private String _userId { get; set; }
        private String _password { get; set; }
        private String _contactEmail { get; set; }
        private String _callbackURL { get; set; }
        private String _serviceURL { get; set; }


        private ChakaPortTypeClient Client
        {
            get
            {
                if(_client == null)
                    _client = new ChakaPortTypeClient(new BasicHttpBinding(), 
					                       new EndpointAddress(_serviceURL));

                return _client;
            }
        }

        private ChakaPortTypeClient _client;
        private String _authToken;

        public void StartSession()
        {
            // Ottengo un token di autorizzazione tramite la funzione "start"
            this._authToken = Client.start(this._userId, this._password,
               new ChakaDevelReference.UserOptions()
               {
                   contactperson = this._contactEmail,
                   soapcallback = this._callbackURL
               });
        }

        public String getAuthToken() { return _authToken; }

        /// <param name="reqUID">Id della richiesta (deve essere univoco)</param>
        /// <returns>Restituisce il numero di correlazione del messaggio inviato al sistema</returns>
        public String SendMessage(String reqUID, String subject, String fileName, byte[] fileContent, 
		                          List<Destination> destinations, DateTime? scheduling)
        {
            // Se la sessione non è stata inizializzata all'esterno 
            // provvedo a farlo qui
            if (getAuthToken() == null) { StartSession(); }

            // Istanzio la lista delle destinazioni (anche se il destinatario è uno solo)
            var destinationList = new DestinationList();
            var dl = new List<Destination>();

            // Preparo la lista delle destinazioni.
            // Se è stato specificato un mittente personalizzato
            // provvedo a impostarlo nel campo cc2.
            // "address" è il numero di telefono a cui verrà spedito il messaggio
            foreach (var destination in destinations)
            {
                var dest = new Destination();
                dest.address = destination.address;
                dest.cc1 = destination.cc1;
                dest.cc2 = destination.cc2;

                dl.Add(dest);
            }
            destinationList.item = dl.ToArray();

            // Creo il fax da spedire e gli associo la lista di destinatari
            // e il testo del messaggio

            var faxMessage = new FAXMessage();
            faxMessage.Item = destinationList;

            // Creo un messaggio contenitore da spedire al sistema e associo il fax
            var message = new ChakaDevelReference.Message();

            // Specifico il subject, che sarà visibile nel sito di Status
            message.subject = subject;
            message.Item = faxMessage;
            message.ItemElementName = ItemChoiceType.fax;

            var doc = new Document();
            doc.contenttype = "ignored";
            doc.uniquename = fileName;
            doc.data = fileContent;

            var docChoice = new DocumentChoiceElement();
            docChoice.Item = doc;

            faxMessage.documents = new List<DocumentChoiceElement>() { docChoice }.ToArray();
            
            // Imposto la schedulazione
            var options = new MessageOptions();

            if (scheduling.HasValue)
            {
                options.scheduling = scheduling.Value;
                options.schedulingSpecified = true;
            }

            message.options = options;

            // Procedo all'invio del messaggio al sistema restituendo il numero di correlazione
            return this.SendChakaMessage(reqUID, message);
        }

        public String SendChakaMessage(String reqUID, Message message)
        {
            // Utilizzo il client creato automaticamente con la reference al servizio soap
            // per effettuare l'invio vero e proprio del messaggio al sistema.
            return this.Client.sendMessage(getAuthToken(), reqUID, message).info.msgid;
        }
    }
}
