﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Chaka;
using Chaka.ChakaDevelReference;

namespace MessageSender
{
    class Program
    {
        static void Main(string[] args)
        {
            String ServiceURL = @"http://soap.kqumg.it/chaka/current/0.9.5/exec";
            String UserId = "example@example.com";
            String Password = "p4ssw0rd";
            String phoneNum0 = "<numero di telefono 1>";
            String phoneNum1 = "<numero di telefono 2>";
            String phoneNum2 = "<numero di telefono 3>";

            String ContactEmail = "mailto: " + UserId;
            String CallbackURL = null;

            var smsSender = new SMSSender(ServiceURL, UserId, Password, ContactEmail, CallbackURL);

            #region Invio di un SMS ad un singolo destinatario

            try
            {
                // Imposto il mittente personalizzato
                smsSender.SetSmsSender("My Sender");

                var correlation = smsSender.SendMessage(
                    Guid.NewGuid().ToString(),
                    "Test SMS via SOAP", 
                    "The content of the Message",

                    // Anche se devo inviare ad un solo destinatario istanzio una lista ed aggiungo un solo elemento
                    new List<Destination>() { 
                    new Destination() { 
                        address = phoneNum0 , 
                        cc2 = "", 
                        cc1 = ""
                    }
                });

                Console.WriteLine(smsSender.getAuthToken());
                Console.WriteLine(correlation);
            }
            catch (Exception e)
            {
                Console.WriteLine(e.Message);
            }

            #endregion

            #region Invio di un SMS a più destinatari

            // Come è possibile notare l'unica differenza tra un invio singolo e un invio 
            // a destinatari multipli è che nel secondo caso si aggiungono più elementi 
            // alla lista delle destinazioni

            try
            {
                // Imposto il mittente personalizzato
                smsSender.SetSmsSender("My Sender");

                var correlation = smsSender.SendMessage(
                    Guid.NewGuid().ToString(),
                    "Test SMS via SOAP",
                    "The content of the Message",
                    new List<Destination>() { 
                    new Destination() { 
                        address = phoneNum0, 
                        cc2 = "", 
                        cc1 = ""
                    },
                    new Destination() { 
                        address = phoneNum1, 
                        cc2 = "", 
                        cc1 = ""
                    } 
                });

                Console.WriteLine(smsSender.getAuthToken());
                Console.WriteLine(correlation);
            }
            catch (Exception e)
            {
                Console.WriteLine(e.Message);
            }

            #endregion

            #region Invio a destinatari multipli con sms merge

            // Nell'invio di sms merge è possibile specificare un messaggio diverso per ogni destinatario

            try
            {
                // Imposto il mittente personalizzato
                smsSender.SetSmsSender("My Sender");

                var correlation = smsSender.SendMessage(
                    Guid.NewGuid().ToString(),
                    "Test SMS via SOAP",
                    new List<DestinationWithMessage>() { 
                    new DestinationWithMessage() { 
                        address = phoneNum0, 
                        cc2 = "", 
                        cc1 = "", 
                        shortMessage = "Contenuto del messaggio 1" 
                    },
                    new DestinationWithMessage() { 
                        address = phoneNum1, 
                        cc2 = "", 
                        cc1 = "", 
                        shortMessage = "Contenuto del messaggio 2" 
                    },
                    new DestinationWithMessage() { 
                        address = phoneNum2,
                        cc2 = "", 
                        cc1 = "", 
                        shortMessage = "Contenuto del messaggio 3" 
                    } 
                });

                Console.WriteLine(smsSender.getAuthToken());
                Console.WriteLine(correlation);
            }
            catch (Exception e)
            {
                Console.WriteLine(e.Message);
            }

            #endregion

            Console.ReadLine();
        }
    }
}
